<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    exclude-result-prefixes="fo"
    version="1.1"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:java="http://xml.apache.org/xslt/java"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:variable
        name="configDoc"
        select="document(project/@config)" />
    <xsl:variable name="ReportName">
        Projektbeschreibung
    </xsl:variable>
    <xsl:include href="Header.xsl" />

    <xsl:template match="project">
        <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
            <fo:layout-master-set>
                <fo:simple-page-master
                    margin-bottom="1.5cm"
                    margin-left="2cm"
                    margin-right="2cm"
                    margin-top="2cm"
                    master-name="simpleA4"
                    page-height="29.7cm"
                    page-width="21cm">
                    <fo:region-body
                        margin-bottom="1cm"
                        margin-top="5cm" />
                    <fo:region-before extent="5cm" />
                    <fo:region-after extent="1cm" />
                </fo:simple-page-master>
            </fo:layout-master-set>
            <fo:page-sequence master-reference="simpleA4">
                <xsl:call-template name="header">
                    <xsl:with-param
                        name="projectName"
                        select="@projectName" />
                </xsl:call-template>
                <xsl:call-template name="footnote" />
                <fo:flow
                    flow-name="xsl-region-body"
                    force-page-count="auto">
                    <fo:table
                        table-layout="fixed"
                        width="100%">
                        <fo:table-column column-width="100%" />
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell>
                                    <fo:block
                                        font-size="10pt"
                                        font-style="italic"
                                        space-after="0.5cm">
                                        Projekt vollst&#x00E4;ndig berechnet
                                    </fo:block>
                                    <xsl:call-template name="Projekt" />
                                    <xsl:apply-templates select="client" />
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                    <xsl:call-template name="terminator" />
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>

    <xsl:template name="Projekt">
        <fo:block
            font-size="14pt"
            font-weight="bold"
            space-before="5mm">
            Projekt
        </fo:block>
        <fo:table
            table-layout="fixed"
            width="100%">
            <fo:table-column column-width="5%" />
            <fo:table-column column-width="27%" />
            <fo:table-column column-width="68%" />
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>Bezeichnung:</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>
                            <xsl:value-of select="@projectName" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>Projekt erstellt am:</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>
                            <xsl:value-of
                                select="java:format(java:java.text.SimpleDateFormat.new('d. MMMM, yyyy'), java:java.util.Date.new())" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>Projektbeschreibung:</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                    <fo:table-cell number-columns-spanned="2">
                        <fo:block
                            font-size="10pt">
                            <xsl:value-of select="@comments" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

<!--     <xsl:call-template name="Auftraggeber" /> -->
<!--     <xsl:call-template name="Ansprechpartner" /> -->

    <xsl:template match="client">
        <fo:block
            font-size="14pt"
            font-weight="bold"
            space-before="5mm">
            <xsl:value-of select="@heading_company" />
        </fo:block>
        <fo:table
            table-layout="fixed"
            width="100%">
            <fo:table-column column-width="5%" />
            <fo:table-column column-width="27%" />
            <fo:table-column column-width="68%" />
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>Anschrift:</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>
                            <xsl:value-of select="@name1" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>
                            <xsl:value-of select="@name2" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>
                            Strasse:
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>
                            <xsl:value-of select="@street" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>Ort:</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>
                            <xsl:value-of select="@plz" />
                            &#160;
                            <xsl:value-of select="@city" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
        <fo:block
            font-size="14pt"
            font-weight="bold"
            space-before="5mm">
            <xsl:value-of select="@heading_contact" />
        </fo:block>
        <fo:table
            table-layout="fixed"
            width="100%">
            <fo:table-column column-width="5%" />
            <fo:table-column column-width="27%" />
            <fo:table-column column-width="68%" />
            <fo:table-body>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>
                            Sachbearbeiter:
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>
                            <xsl:value-of select="$configDoc/config/@user" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>
                            Telefon:
                        </fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>
                            <xsl:value-of select="$configDoc/config/@phone" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>Fax:</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>
                            <xsl:value-of select="$configDoc/config/@fax" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                    <fo:table-cell>
                        <fo:block />
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>E-Mail:</fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <fo:block>
                            <xsl:value-of select="$configDoc/config/@eMail" />
                        </fo:block>
                    </fo:table-cell>
                </fo:table-row>
            </fo:table-body>
        </fo:table>
    </xsl:template>

</xsl:stylesheet>
